implementation module wstateaccess


//	Clean Object I/O library, version 1.0.1

import	StdInt, StdBool, StdList
import	commondef, wstate


//	Higher order access functions on [WElementHandle`]

setWElements :: ([arg] WItemHandle` .s -> ([arg],WItemHandle`,.s)) ![arg] ![WElementHandle`] !.s
															   -> (![arg],![WElementHandle`],!.s)
setWElements f args itemHs s
	| isEmpty args || isEmpty itemHs
	= (args,itemHs,s)
	# (itemH,itemHs)	= HdTl itemHs
	# (args,itemH, s)	= setWElements` f args itemH  s
	# (args,itemHs,s)	= setWElements  f args itemHs s
	= (args,[itemH:itemHs],s)
where
	setWElements` :: ([arg] WItemHandle` .s -> ([arg],WItemHandle`,.s)) ![arg] !WElementHandle` !.s
																	-> (![arg],!WElementHandle`,!.s)
	setWElements` f args (WRecursiveHandle` itemHs dRecKind) s
		# (args,itemHs,s)	= setWElements f args itemHs s
		= (args,WRecursiveHandle` itemHs dRecKind,s)
	setWElements` f args (WItemHandle` itemH) s
		# (args,itemH,s)	= f args itemH s
		= (args,WItemHandle` itemH,s)

setAllWElements :: (WItemHandle` .s -> (WItemHandle`,.s)) ![WElementHandle`] !.s
													  -> (![WElementHandle`],!.s)
setAllWElements f [itemH:itemHs] s
	# (itemH, s)	= setWElement     f itemH  s
	# (itemHs,s)	= setAllWElements f itemHs s
	= ([itemH:itemHs],s)
where
	setWElement :: (WItemHandle` .s -> (WItemHandle`,.s)) !WElementHandle` !.s -> (!WElementHandle`,!.s)
	setWElement f (WRecursiveHandle` itemHs wRecKind) s
		# (itemHs,s)	= setAllWElements f itemHs s
		= (WRecursiveHandle` itemHs wRecKind,s)
	setWElement f (WItemHandle` itemH) s
		# (itemH,s)		= f itemH s
		= (WItemHandle` itemH,s)
setAllWElements _ _ s
	= ([],s)

setWElement :: (Id WItemHandle` .s -> (Bool,WItemHandle`,.s)) !Id ![WElementHandle`] !.s -> (!Bool,![WElementHandle`],!.s)
setWElement f id itemHs s
	| isEmpty itemHs
	= (False,itemHs,s)
	# (itemH,itemHs)	= HdTl itemHs
	# (done,itemH,s)	= setWElement` f id itemH  s
	| done
	= (done,[itemH:itemHs],s)
	# (done,itemHs,s)	= setWElement  f id itemHs s
	= (done,[itemH:itemHs],s)
where
	setWElement` :: (Id WItemHandle` .s -> (Bool,WItemHandle`,.s)) !Id !WElementHandle` !.s -> (!Bool,!WElementHandle`,!.s)
	setWElement` f id (WRecursiveHandle` itemHs dRecKind) s
		# (done,itemHs,s)	= setWElement f id itemHs s
		= (done,WRecursiveHandle` itemHs dRecKind,s)
	setWElement` f id (WItemHandle` itemH) s
		# (done,itemH,s)	= f id itemH s
		= (done,WItemHandle` itemH,s)

setWItemHandle :: (WItemHandle` .s -> (Bool,WItemHandle`,.s)) ![WElementHandle`] !.s -> (!Bool,![WElementHandle`],!.s)
setWItemHandle f itemHs s
	| isEmpty itemHs
	= (False,itemHs,s)
	# (itemH,itemHs)	= HdTl itemHs
	# (done,itemH,s)	= setWItemHandle` f itemH  s
	| done
	= (done,[itemH:itemHs],s)
	# (done,itemHs,s)	= setWItemHandle  f itemHs s
	= (done,[itemH:itemHs],s)
where
	setWItemHandle` :: (WItemHandle` .s -> (Bool,WItemHandle`,.s)) !WElementHandle` !.s -> (!Bool,!WElementHandle`,!.s)
	setWItemHandle` f (WRecursiveHandle` itemHs dRecKind) s
		# (done,itemHs,s)	= setWItemHandle f itemHs s
		= (done,WRecursiveHandle` itemHs dRecKind,s)
	setWItemHandle` f (WItemHandle` itemH) s
		# (done,itemH,s)	= f itemH s
		= (done,WItemHandle` itemH,s)


//	Determine the list of window items that can obtain the keyboard input focus.

getWElementKeyFocusIds` :: !Bool ![WElementHandle`] -> [FocusItem]
getWElementKeyFocusIds` shownContext [itemH:itemHs]
	= getWElementKeyFocusIds`` shownContext itemH++getWElementKeyFocusIds` shownContext itemHs
where
	getWElementKeyFocusIds`` :: !Bool !WElementHandle` -> [FocusItem]
	getWElementKeyFocusIds`` shownContext (WRecursiveHandle` itemHs _)
		= getWElementKeyFocusIds` shownContext itemHs
	getWElementKeyFocusIds`` shownContext (WItemHandle` {wItemNr`,wItemKind`,wItemShow`,wItemAtts`,wItems`})
		| wItemKind`==IsEditControl
		= focus
		| keySensitive && hasKeyAtt
		= focus
		= getWElementKeyFocusIds` (shownContext && wItemShow`) wItems`
	where
		focus			= [{focusNr=wItemNr`,focusShow=shownContext}]
		hasKeyAtt		= Contains isControlKeyboard` wItemAtts`
		keySensitive	= wItemKind`==IsCustomControl
getWElementKeyFocusIds` _ _
	= []


instance == WRecursiveKind
where
	(==) :: !WRecursiveKind !WRecursiveKind -> Bool
	(==) IsWListLSHandle	wRecKind	= case wRecKind of
											IsWListLSHandle		-> True
											_					-> False
	(==) IsWExtendLSHandle	wRecKind	= case wRecKind of
											IsWExtendLSHandle	-> True
											_					-> False
	(==) IsWChangeLSHandle	wRecKind	= case wRecKind of
											IsWChangeLSHandle	-> True
											_					-> False


//	Access to the additional WItemInfo` field of a WItemHandle` (partial functions!).

getWItemRadioInfo` :: !WItemInfo` -> RadioInfo`
getWItemRadioInfo` (RadioInfo` info) = info

getWItemCheckInfo` :: !WItemInfo` -> CheckInfo`
getWItemCheckInfo` (CheckInfo` info) = info

getWItemPopUpInfo` :: !WItemInfo` -> PopUpInfo`
getWItemPopUpInfo` (PopUpInfo` info) = info

getWItemSliderInfo` :: !WItemInfo` -> SliderInfo`
getWItemSliderInfo` (SliderInfo` info) = info

getWItemTextInfo` :: !WItemInfo` -> TextInfo
getWItemTextInfo` (TextInfo` info) = info

getWItemEditInfo` :: !WItemInfo` -> EditInfo
getWItemEditInfo` (EditInfo` info) = info

getWItemButtonInfo` :: !WItemInfo` -> ButtonInfo
getWItemButtonInfo` (ButtonInfo` info) = info

getWItemCustomButtonInfo` :: !WItemInfo` -> CustomButtonInfo
getWItemCustomButtonInfo` (CustomButtonInfo` info) = info

getWItemCustomInfo` :: !WItemInfo` -> CustomInfo
getWItemCustomInfo` (CustomInfo` info) = info

getWItemCompoundInfo` :: !WItemInfo` -> CompoundInfo
getWItemCompoundInfo` (CompoundInfo` info) = info


//	General access rules for (Window/Control)Attribute`:

isWindowResize` :: !WindowAttribute` -> Bool
isWindowResize` WindowResize`						= True
isWindowResize` _									= False

isWindowItemSpace` :: !WindowAttribute` -> Bool
isWindowItemSpace` (WindowItemSpace` _ _)			= True
isWindowItemSpace` _								= False

isWindowHMargin` :: !WindowAttribute` -> Bool
isWindowHMargin` (WindowHMargin` _ _)				= True
isWindowHMargin` _									= False

isWindowVMargin` :: !WindowAttribute` -> Bool
isWindowVMargin` (WindowVMargin` _ _)				= True
isWindowVMargin` _									= False

isWindowMinimumSize` :: !WindowAttribute` -> Bool
isWindowMinimumSize` (WindowMinimumSize` _)			= True
isWindowMinimumSize` _								= False

getWindowHMargin` :: !WindowAttribute` -> (Int,Int)
getWindowHMargin` (WindowHMargin` l r)				= (l,r)

getWindowVMargin` :: !WindowAttribute` -> (Int,Int)
getWindowVMargin` (WindowVMargin` t b)				= (t,b)

getWindowItemSpace` :: !WindowAttribute` -> (Int,Int)
getWindowItemSpace` (WindowItemSpace` hspace vspace)= (hspace,vspace)

getWindowMinimumSize` :: !WindowAttribute` -> Size
getWindowMinimumSize` (WindowMinimumSize` size)		= size


isControlId` :: !ControlAttribute` -> Bool
isControlId` (ControlId` _)		= True
isControlId` _					= False

isControlPos` :: !ControlAttribute` -> Bool
isControlPos` (ControlPos` _)	= True
isControlPos` _					= False

isControlSize` :: !ControlAttribute` -> Bool
isControlSize` (ControlSize` _)	= True
isControlSize` _				= False

isControlMinimumSize` :: !ControlAttribute` -> Bool
isControlMinimumSize` (ControlMinimumSize` _)	= True
isControlMinimumSize` _							= False

isControlResize` :: !ControlAttribute` -> Bool
isControlResize` (ControlResize` _)	= True
isControlResize` _					= False

isControlSelectState` :: !ControlAttribute` -> Bool
isControlSelectState` (ControlSelectState` _)	= True
isControlSelectState` _							= False

isControlKeyboard` :: !ControlAttribute` -> Bool
isControlKeyboard` (ControlKeyboard` _ )	= True
isControlKeyboard` _						= False

isControlItemSpace` :: !ControlAttribute` -> Bool
isControlItemSpace` (ControlItemSpace` _ _)	= True
isControlItemSpace` _						= False

isControlHMargin` :: !ControlAttribute` -> Bool
isControlHMargin` (ControlHMargin` _ _)	= True
isControlHMargin` _						= False

isControlVMargin` :: !ControlAttribute` -> Bool
isControlVMargin` (ControlVMargin` _ _)	= True
isControlVMargin` _						= False

isControlHScroll` :: !ControlAttribute` -> Bool
isControlHScroll` (ControlHScroll` _)	= True
isControlHScroll` _						= False

isControlVScroll` :: !ControlAttribute` -> Bool
isControlVScroll` (ControlVScroll` _)	= True
isControlVScroll` _						= False


getControlId` :: !ControlAttribute` -> Id
getControlId` (ControlId` id)	= id

getControlPos` :: !ControlAttribute` -> ItemPos
getControlPos` (ControlPos` pos)	= pos

getControlMinimumSize` :: !ControlAttribute` -> Size
getControlMinimumSize` (ControlMinimumSize` size) = size

getControlResize` :: !ControlAttribute` -> ControlResizeFunction
getControlResize` (ControlResize` f)	= f

getControlSelectState` :: !ControlAttribute` -> SelectState
getControlSelectState` (ControlSelectState` select) = select

getControlItemSpace` :: !ControlAttribute` -> (Int,Int)
getControlItemSpace` (ControlItemSpace` hspace vspace)	= (hspace,vspace)

getControlHMargin` :: !ControlAttribute` -> (Int,Int)
getControlHMargin` (ControlHMargin` l r)	= (l,r)

getControlVMargin` :: !ControlAttribute` -> (Int,Int)
getControlVMargin` (ControlVMargin` t b)	= (t,b)

getControlHScrollFunction` :: !ControlAttribute` -> ScrollFunction
getControlHScrollFunction` (ControlHScroll` f)	= f

getControlVScrollFunction` :: !ControlAttribute` -> ScrollFunction
getControlVScrollFunction` (ControlVScroll` f)	= f
